//---------------------------------------------------------------------------

#include <vcl.h>

#pragma hdrstop

#include "LinkLabel.h"
#pragma package(smart_init)
//---------------------------------------------------------------------------
// ValidCtrCheck is used to assure that the components created do not have
// any pure virtual functions.
//

static inline void ValidCtrCheck(TLink *)
{
	new TLink(NULL);
}
static inline void ValidCtrCheck(TMail *)
{
	new TMail(NULL);
}
//---------------------------------------------------------------------------
__fastcall TLinkLabel::TLinkLabel(TComponent* Owner)
	: TCustomLabel(Owner)
{
	Font->Color=clNavy;
	//Font->Style=LinkStyle;
	Cursor=crHandPoint;
	OnClick=Polacz;
	OnMouseEnter=DodajPodkreslenie;
	OnMouseLeave=UsunPodkreslenie;
}
//---------------------------------------------------------------------------
namespace Linklabel
{
	void __fastcall PACKAGE Register()
	{
		TComponentClass classes[1] = {__classid(TLinkLabel)};
		RegisterComponents("Helion", classes, 0);
	}
}
//---------------------------------------------------------------------------
void __fastcall TLinkLabel::DodajPodkreslenie(TObject* Sender)
{
	TFontStyles LinkStyle=Font->Style;
	LinkStyle << fsUnderline;
	Font->Style=LinkStyle;
}

void __fastcall TLinkLabel::UsunPodkreslenie(TObject* Sender)
{
	TFontStyles LinkStyle=Font->Style;
	LinkStyle >> fsUnderline;
	Font->Style=LinkStyle;
}

void __fastcall TLinkLabel::Polacz(TObject* Sender)
{
	Font->Color=clBlack;
	ShellExecute(NULL,"open",Adres.c_str(),NULL,NULL,SW_NORMAL);
}
//---------------------------------------------------------------------------
__fastcall TLink::TLink(TComponent* Owner)
	:TLinkLabel(Owner)
{
	Adres="http://helion.pl";
}

bool TLink::SprawdzAdres(AnsiString AAdres)
{
	return AAdres.SubString(1,7)=="http://";
}

void __fastcall TLink::SetAdres(AnsiString AAdres)
{
	if (!SprawdzAdres(AAdres)) AAdres="http://"+AAdres;
	FAdres=AAdres;
}
//---------------------------------------------------------------------------
__fastcall TMail::TMail(TComponent* Owner)
	:TLinkLabel(Owner)
{
	Adres="mailto:helion@helion.pl";
}

bool TMail::SprawdzAdres(AnsiString AAdres)
{
	return AAdres.SubString(1,7)=="mailto:";
}

void __fastcall TMail::SetAdres(AnsiString AAdres)
{
	if (!SprawdzAdres(AAdres)) AAdres="mailto:"+AAdres;
	FAdres=AAdres;
}
//---------------------------------------------------------------------------

